/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.registry;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.registry.ChildProcessRegistryEntries;
import com.gamedash.daemon.process.childProcess.registry.ChildProcessRegistryException;
import com.google.gson.annotations.SerializedName;
import java.text.MessageFormat;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ChildProcessRegistryEntry {
    @SerializedName(value="id")
    private int id;
    private transient ChildProcess childProcess;

    public ChildProcessRegistryEntry() {
    }

    public ChildProcessRegistryEntry(@NonNull Integer id) {
        this.id = id;
    }

    public Integer getId() {
        if (this.childProcess != null) {
            return this.childProcess.getId();
        }
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ChildProcess getChildProcess() {
        return this.childProcess;
    }

    public void setChildProcess(ChildProcess childProcess) {
        Integer newId;
        if (this.getId() != null && (newId = childProcess.getId()) != null && !this.getId().equals(newId)) {
            throw new ChildProcessRegistryException(MessageFormat.format("Child process id {0,number,#} must match {0,number,#}", childProcess.getId(), this.getId()));
        }
        this.childProcess = childProcess;
    }

    public static ChildProcessRegistryEntry get(int id) {
        return ChildProcessRegistryEntries.get(id);
    }

    public static ChildProcessRegistryEntry getFromChildProcess(ChildProcess childProcess) {
        ChildProcessRegistryEntry entry = ChildProcessRegistryEntry.get(childProcess.getId());
        entry.setChildProcess(childProcess);
        return entry;
    }

    public static ChildProcessRegistryEntry create() {
        return new ChildProcessRegistryEntry();
    }

    public static ChildProcessRegistryEntry create(int id) {
        return new ChildProcessRegistryEntry(id);
    }

    public static ChildProcessRegistryEntry createFromChildProcess(ChildProcess childProcess) {
        Integer id = childProcess.getId();
        ChildProcessRegistryEntry entry = id != null ? ChildProcessRegistryEntry.create(id) : ChildProcessRegistryEntry.create();
        entry.setChildProcess(childProcess);
        return entry;
    }
}

