/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.registry;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.registry.ChildProcessRegistryEntry;
import com.gamedash.daemon.process.childProcess.registry.store.IChildProcessRegistryStore;
import com.gamedash.daemon.process.childProcess.registry.store.file.ChildProcessRegistryFileStore;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ChildProcessRegistry.class);
    private final IChildProcessRegistryStore store;
    private final List<ChildProcessRegistryEntry> entries = new CopyOnWriteArrayList<ChildProcessRegistryEntry>();

    public ChildProcessRegistry() throws Exception {
        this.store = new ChildProcessRegistryFileStore();
        this.synchronize();
    }

    public ChildProcessRegistry(IChildProcessRegistryStore store) {
        this.store = store;
    }

    public List<ChildProcessRegistryEntry> getEntries() {
        return this.entries;
    }

    public void addEntries(ChildProcess[] childProcesses) {
        this.addEntries((ChildProcess[])Arrays.stream(childProcesses).map(ChildProcessRegistryEntry::getFromChildProcess).toArray());
    }

    public void addEntries(ChildProcessRegistryEntry[] entries) {
        this.entries.addAll(Arrays.asList(entries));
        try {
            this.store.addEntries(entries);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    public void addEntryIfNotFound(ChildProcess childProcess) {
        this.addEntry(ChildProcessRegistryEntry.getFromChildProcess(childProcess));
    }

    public void addEntryIfNotFound(ChildProcessRegistryEntry entry) {
        try {
            this.store.addEntry(entry);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    public void addEntry(ChildProcess childProcess) {
        this.addEntry(childProcess, true);
    }

    public void addEntry(ChildProcess childProcess, boolean synchronize) {
        this.addEntry(ChildProcessRegistryEntry.getFromChildProcess(childProcess), synchronize);
    }

    public void addEntry(ChildProcessRegistryEntry entry) {
        this.addEntry(entry, true);
    }

    public void addEntry(ChildProcessRegistryEntry entry, boolean synchronize) {
        this.entries.add(entry);
        try {
            if (synchronize) {
                this.store.addEntry(entry);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
    }

    public ChildProcessRegistryEntry getEntry(int id) {
        for (ChildProcessRegistryEntry entry : this.getEntries()) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        return null;
    }

    public void removeEntry(int id) {
        this.removeEntry(id, true);
    }

    public void removeEntry(int id, boolean synchronize) {
        try {
            if (synchronize) {
                this.store.removeEntry(id);
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
        this.entries.removeIf(entry -> entry.getId() == id);
    }

    public void clearEntries() throws Exception {
        this.store.clearEntries();
    }

    public void synchronize() throws Exception {
        for (ChildProcessRegistryEntry localEntry : this.getEntries()) {
            this.store.addEntryIfNotFound(localEntry);
        }
        this.entries.clear();
        this.entries.addAll(this.store.getEntries());
    }
}

