/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process.childProcess.io;

import com.gamedash.daemon.platform.windows.bridge.IWindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcess;
import com.gamedash.daemon.platform.windows.process.childProcess.io.IWindowsPlatformChildProcessOnOutputCallback;
import com.gamedash.daemon.platform.windows.process.childProcess.io.WindowsPlatformChildProcessIOException;
import com.gamedash.daemon.platform.windows.process.childProcess.io.WindowsPlatformChildProcessOutputItem;
import java.util.ArrayList;
import java.util.List;

public class WindowsPlatformChildProcessIo {
    private WindowsPlatformChildProcess childProcess;
    private List<OnOutputHandle> onOutputHandles = new ArrayList<OnOutputHandle>();
    private List<IWindowsPlatformChildProcessOnOutputCallback> onOutputCallbacks = new ArrayList<IWindowsPlatformChildProcessOnOutputCallback>();
    private boolean isListening = false;
    private IWindowsBridge.IChildProcessOnOutputCallback onOutputListener;

    public WindowsPlatformChildProcessIo(WindowsPlatformChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public void onOutput(IWindowsPlatformChildProcessOnOutputCallback callback) {
        this.onOutputCallbacks.add(callback);
    }

    public boolean isListening() {
        return this.isListening;
    }

    private void setIsListening(boolean isListening) {
        this.isListening = isListening;
    }

    public void listen() throws WindowsPlatformChildProcessIOException {
        if (this.isListening()) {
            throw new WindowsPlatformChildProcessIOException("Already listening");
        }
        this.setIsListening(true);
        this.onOutputListener = (value, isError) -> this.onOutputCallbacks.forEach(callback -> callback.method(new WindowsPlatformChildProcessOutputItem(value, isError)));
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().onChildProcessOutput(this.childProcess.getId(), this.onOutputListener));
        if (result.isError()) {
            throw new WindowsPlatformChildProcessIOException(result.getErrorMessage());
        }
        OnOutputHandle handle = new OnOutputHandle(this.childProcess, result.getResultValueAsInteger());
        this.onOutputHandles.add(handle);
    }

    public void destroy() {
        for (OnOutputHandle handle : this.onOutputHandles) {
            handle.remove();
        }
    }

    public static class OnOutputHandle {
        private WindowsPlatformChildProcess childProcess;
        private int index;

        public OnOutputHandle(WindowsPlatformChildProcess childProcess, int index) {
            this.index = index;
            this.childProcess = childProcess;
        }

        public void remove() {
            WindowsBridge.getInstance().removeChildProcessOnOutputCallback(this.childProcess.getId(), this.index);
        }
    }
}

