/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process.childProcess;

import com.gamedash.daemon.platform.windows.bridge.IWindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridgeException;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.WindowsProcess;
import com.gamedash.daemon.platform.windows.process.WindowsProcesses;
import com.gamedash.daemon.platform.windows.process.childProcess.IWindowsPlatformChildProcessOnExitCallback;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcessException;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcessUser;
import com.gamedash.daemon.platform.windows.process.childProcess.WindowsPlatformChildProcesses;
import com.gamedash.daemon.platform.windows.process.childProcess.io.WindowsPlatformChildProcessIo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsPlatformChildProcess {
    private static Logger logger = LoggerFactory.getLogger(WindowsPlatformChildProcess.class);
    private Integer id;
    private final List<IWindowsPlatformChildProcessOnExitCallback> onExitCallbacks = new ArrayList<IWindowsPlatformChildProcessOnExitCallback>();
    private IWindowsBridge.IChildProcessOnExitCallback onExitListenerCallback;
    private WindowsPlatformChildProcessIo io = new WindowsPlatformChildProcessIo(this);
    private WindowsPlatformChildProcessUser user;
    private File workingDirectory = new File("C:\\");
    private boolean isListeningForExit = false;
    private boolean hasExited = false;

    public Integer getId() {
        return this.id;
    }

    private void setId(int id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spawn(String executable, String[] args) throws Exception {
        WindowsPlatformChildProcessUser user = this.getUser();
        WindowsBridgeResult result = user != null && user.getSystemUser().hasStoredPassword() ? WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcessAsUser(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath(), user.getSystemUser().getName(), user.getSystemUser().getStoredPassword())) : WindowsBridgeResults.get(WindowsBridge.getInstance().spawnChildProcess(executable, String.join((CharSequence)" ", args), this.getWorkingDirectory().getPath()));
        try {
            if (result.isError()) {
                throw new WindowsPlatformChildProcessException(result.getErrorMessage());
            }
            this.setId(result.getResultValueAsInteger());
            this.onExit(() -> this.getIo().destroy());
            Thread ioListenerThread = this.createIoListenerThread();
            ioListenerThread.start();
            Thread exitListenerThread = this.createExitListenerThread();
            exitListenerThread.start();
        }
        finally {
            result.delete();
        }
    }

    public void stop() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().stopChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsPlatformChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsPlatformChildProcessException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public int getExitCode() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessExitCode(this.getId()));
        return result.getResultValueAsInteger();
    }

    public void delete() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().deleteChildProcess(this.getId()));
        try {
            if (result.isError()) {
                throw new WindowsPlatformChildProcessException(result.getErrorMessage());
            }
            WindowsPlatformChildProcesses.getAll().remove(this);
        }
        finally {
            result.delete();
        }
    }

    public WindowsPlatformChildProcessIo getIo() {
        return this.io;
    }

    public void waitForExit() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.onExit(latch::countDown);
        latch.await();
    }

    public void sendInput(String input) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().childProcessSendInput(this.getId(), input));
        try {
            if (result.isError()) {
                throw new WindowsBridgeException(result.getErrorMessage());
            }
        }
        finally {
            result.delete();
        }
    }

    public void onExit(IWindowsPlatformChildProcessOnExitCallback callback) {
        this.onExitCallbacks.add(callback);
    }

    public boolean hasExited() {
        return this.hasExited;
    }

    private void setHasExited(boolean exited) {
        this.hasExited = exited;
    }

    private void listenForExit() throws Exception {
        if (this.isListeningForExit) {
            throw new WindowsPlatformChildProcessException("Already listening for exit");
        }
        this.isListeningForExit = true;
        CountDownLatch latch = new CountDownLatch(1);
        this.onExitListenerCallback = () -> {
            this.setHasExited(true);
            this.onExitCallbacks.forEach(IWindowsPlatformChildProcessOnExitCallback::method);
            latch.countDown();
        };
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().onChildProcessExit(this.getId(), this.onExitListenerCallback));
        if (result.isError()) {
            throw new WindowsPlatformChildProcessException(result.getErrorMessage());
        }
        latch.await();
        WindowsBridge.getInstance().removeChildProcessOnExitCallback(this.getId(), this.id);
    }

    public List<WindowsProcess> getChildren() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getChildProcessChildren(this.id));
        if (result.isError()) {
            throw new WindowsPlatformChildProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsProcess> processes = new ArrayList<WindowsProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public WindowsPlatformChildProcessUser getUser() {
        return this.user;
    }

    public void setUser(WindowsPlatformChildProcessUser user) {
        this.user = user;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    private Thread createIoListenerThread() {
        Thread thread = new Thread(() -> {
            try {
                this.getIo().listen();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.setName(String.format("Windows IO listener listener thread for process %d", this.getId()));
        return thread;
    }

    private Thread createExitListenerThread() {
        Thread thread = new Thread(() -> {
            try {
                this.listenForExit();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.setName(String.format("Windows exit listener thread for process %d", this.getId()));
        return thread;
    }
}

