/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.common.singleton.SingletonList;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.WindowsProcess;
import com.gamedash.daemon.platform.windows.process.WindowsProcessException;
import com.gamedash.daemon.process.IProcess;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsProcesses {
    private static final SingletonList<WindowsProcess> processes = new SingletonList<WindowsProcess>(){

        @Override
        public boolean compare(WindowsProcess a, WindowsProcess b) {
            return a.getId() == b.getId();
        }
    };

    public static List<WindowsProcess> getAll() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getAllProcesses());
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsProcess> processes = new ArrayList<WindowsProcess>();
        for (JsonElement jsonElement : result.getResultValueAsJson().getAsJsonArray()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            WindowsProcess process = WindowsProcesses.get(jsonObject.get("id").getAsInt());
            process.dataLayer.setValue("name", jsonObject.get("name").getAsString());
            process.dataLayer.setValue("fileName", jsonObject.get("fileName").getAsString());
            ArrayList<String> argumentsList = new ArrayList<String>();
            for (JsonElement argumentJsonArrayElement : jsonObject.get("arguments").getAsJsonArray()) {
                argumentsList.add(argumentJsonArrayElement.getAsString());
            }
            process.dataLayer.setValue("arguments", argumentsList.toArray(new String[0]));
            process.dataLayer.setValue("workingDirectory", new File(jsonObject.get("workingDirectory").getAsString()));
            processes.add(process);
        }
        return processes;
    }

    public static WindowsProcess get(int id) {
        WindowsProcess process = processes.find(_process -> _process.getId() == id);
        if (process == null) {
            process = new WindowsProcess(id);
            processes.add(process);
        }
        return process;
    }

    public static boolean exists(int id) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().processExists(id));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsBoolean();
    }

    public static void stop(WindowsProcess[] processes) throws Exception {
        for (WindowsProcess process : processes) {
            process.stop();
        }
    }

    public static void kill(WindowsProcess[] processes) throws Exception {
        for (WindowsProcess process : processes) {
            process.kill();
        }
    }

    public static WindowsProcess[] filter(IProcess<?>[] processes) {
        ArrayList<WindowsProcess> filtered = new ArrayList<WindowsProcess>();
        for (IProcess<?> process : processes) {
            if (!(process instanceof WindowsProcess)) continue;
            filtered.add((WindowsProcess)process);
        }
        return (WindowsProcess[])filtered.toArray(WindowsProcess[]::new);
    }
}

