/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.platform.process.AbstractProcess;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.DataLayer;
import com.gamedash.daemon.platform.windows.process.WindowsProcessException;
import com.gamedash.daemon.platform.windows.process.WindowsProcesses;
import com.gamedash.daemon.platform.windows.process.WindowsResourceLimitEnforcementManager;
import com.gamedash.daemon.platform.windows.process.priority.WindowsPlatformProcessPriorityEnum;
import com.gamedash.daemon.platform.windows.process.priority.WindowsPlatformProcessPriorityHelper;
import com.gamedash.daemon.process.ProcessResourceUsageResult;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.IResourceLimitEnforcementManager;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class WindowsProcess
extends AbstractProcess<WindowsProcess> {
    public DataLayer dataLayer = new DataLayer(this);

    public WindowsProcess(int id) {
        super(id);
    }

    @Override
    public String[] getCommandLine() throws Exception {
        String[] cmdLine = new String[]{this.getFileName()};
        return ArrayUtils.addAll(cmdLine, this.getArguments());
    }

    @Override
    public String getName() throws Exception {
        return (String)this.dataLayer.getValue("name");
    }

    public String getFileName() throws Exception {
        return (String)this.dataLayer.getValue("fileName");
    }

    public String[] getArguments() throws Exception {
        return (String[])this.dataLayer.getValue("arguments");
    }

    @Override
    public File getWorkingDirectory() throws Exception {
        return (File)this.dataLayer.getValue("workingDirectory");
    }

    @Override
    public boolean hasExited() throws Exception {
        if (this.exited != null) {
            return this.exited;
        }
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().processHasExited(this.getId()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsBoolean();
    }

    @Override
    public void kill() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().killProcess(this.getId()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
    }

    @Override
    public void kill(String signal) throws Exception {
        this.kill();
    }

    @Override
    public void stop() throws Exception {
        this.kill();
    }

    @Override
    public List<WindowsProcess> getChildren() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessChildren(this.getId()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        ArrayList<WindowsProcess> processes = new ArrayList<WindowsProcess>();
        for (String id : result.getResultValueAsList()) {
            processes.add(WindowsProcesses.get(Integer.parseInt(id)));
        }
        return processes;
    }

    public void setProcessorAffinity(List<Processor> processors) throws Exception {
        this.setProcessorAffinity(Processors.toMask(processors));
    }

    public void setProcessorAffinity(long mask) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessProcessorAffinity(this.getId(), mask));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
    }

    public WindowsPlatformProcessPriorityEnum getPriority() throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessPriority(this.getId()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        int integer = result.getResultValueAsInteger();
        for (WindowsPlatformProcessPriorityEnum priority : WindowsPlatformProcessPriorityEnum.values()) {
            if (priority.getInteger() != integer) continue;
            return priority;
        }
        return null;
    }

    public void setPriority(WindowsPlatformProcessPriorityEnum priority) throws Exception {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().setProcessPriority(this.getId(), priority.getInteger()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
    }

    @Override
    public ProcessResourceUsageResult getResourceUsage() throws Exception {
        return new ProcessResourceUsageResult(this.getCpuResourceUsage(), this.getRamMbResourceUsage());
    }

    @Override
    public void enforceResourceLimits() throws Exception {
        this.enforceCPUResourceLimit();
    }

    public void enforceCPUResourceLimit() throws Exception {
        CPUResourceLimit cpu = this.getCPUResourceLimit();
        if (cpu.getProcessorAffinity() != null) {
            this.ensureAffinityProcessorsIsInRange(cpu.getProcessorAffinity());
            this.setProcessorAffinity(cpu.getProcessorAffinity());
        }
        if (cpu.getPriority() != null) {
            this.setPriority(WindowsPlatformProcessPriorityHelper.from(cpu.getPriority()));
        }
    }

    @Override
    protected IResourceLimitEnforcementManager createResourceLimitEnforcementManager() {
        return new WindowsResourceLimitEnforcementManager(this);
    }

    private double getCpuResourceUsage() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessResourceUsageCpuPercentage(this.getId()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsDouble();
    }

    private long getRamMbResourceUsage() {
        WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcessResourceUsageRamMb(this.getId()));
        if (result.isError()) {
            throw new WindowsProcessException(result.getErrorMessage());
        }
        return result.getResultValueAsLong();
    }
}

