/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.process;

import com.gamedash.daemon.common.dataLayer.AbstractDataLayer;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.platform.windows.process.WindowsProcess;
import com.gamedash.daemon.platform.windows.process.WindowsProcessException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;

public class DataLayer
extends AbstractDataLayer {
    public DataLayer(WindowsProcess process) {
        this.registerValueSource(new String[]{"name", "fileName", "arguments", "workingDirectory"}, (String name) -> {
            WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().getProcess(process.getId()));
            if (result.isError()) {
                throw new WindowsProcessException(result.getErrorMessage());
            }
            JsonObject jsonObject = result.getResultValueAsJson().getAsJsonObject();
            this.setValue("name", jsonObject.get("name").getAsString());
            this.setValue("fileName", jsonObject.get("fileName").getAsString());
            ArrayList<String> argumentsList = new ArrayList<String>();
            for (JsonElement argumentJsonArrayElement : jsonObject.get("arguments").getAsJsonArray()) {
                argumentsList.add(argumentJsonArrayElement.getAsString());
            }
            this.setValue("arguments", argumentsList.toArray(new String[0]));
            this.setValue("workingDirectory", new File(jsonObject.get("workingDirectory").getAsString()));
            return this.getValue(name);
        });
    }
}

