/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.windows.bridge.result;

import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;

public class WindowsBridgeResult {
    private long index;

    public WindowsBridgeResult(long index) {
        this.index = index;
    }

    public long getIndex() {
        return this.index;
    }

    public void delete() {
        if (WindowsBridgeResults.exists(this.getIndex())) {
            WindowsBridge.getInstance().deleteResult(this.getIndex());
        }
    }

    public boolean isError() {
        return WindowsBridge.getInstance().resultIsError(this.getIndex());
    }

    public String getErrorMessage() {
        return WindowsBridge.getInstance().getResultErrorMessage(this.getIndex());
    }

    public String getResultValueAsString() {
        return WindowsBridge.getInstance().getResultValueAsString(this.getIndex());
    }

    public JsonElement getResultValueAsJson() {
        return new JsonParser().parse(WindowsBridge.getInstance().getResultValueAsJson(this.getIndex()));
    }

    public boolean getResultValueAsBoolean() {
        return WindowsBridge.getInstance().getResultValueAsBoolean(this.getIndex());
    }

    public int getResultValueAsInteger() {
        return WindowsBridge.getInstance().getResultValueAsInteger(this.getIndex());
    }

    public long getResultValueAsLong() {
        return WindowsBridge.getInstance().getResultValueAsLong(this.getIndex());
    }

    public double getResultValueAsDouble() {
        return WindowsBridge.getInstance().getResultValueAsDouble(this.getIndex());
    }

    public List<String> getResultValueAsList() {
        return Arrays.asList(this.getResultValueAsString().split(","));
    }
}

