/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.process;

import com.gamedash.daemon.platform.linux.process.LinuxProcess;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class LinuxProcesses {
    private static volatile List<LinuxProcess> processes = new ArrayList<LinuxProcess>();

    public static List<LinuxProcess> getAll() {
        ArrayList<LinuxProcess> processes = new ArrayList<LinuxProcess>();
        File[] files = new File("/proc").listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || !StringUtils.isNumeric(file.getName())) continue;
                processes.add(LinuxProcesses.get(Integer.parseInt(file.getName())));
            }
        }
        return processes;
    }

    public static synchronized LinuxProcess get(int id) {
        for (LinuxProcess process : processes) {
            if (process.getId() != id) continue;
            return process;
        }
        LinuxProcess process = new LinuxProcess(id);
        processes.add(process);
        return process;
    }

    public static boolean exists(int id) {
        return new File("/proc/" + id).exists();
    }

    public static void stop(LinuxProcess[] processes) throws Exception {
        LinuxProcesses.kill(processes, "TERM");
    }

    public static void kill(LinuxProcess[] processes, String signal) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(false);
        childProcess.setUseShell(false);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("-" + signal);
        for (LinuxProcess process : processes) {
            args.add(Long.toString(process.getId()));
        }
        childProcess.spawn("kill", args.toArray(new String[0]));
        childProcess.waitForExit();
    }

    public static LinuxProcess[] filter(IProcess[] processes) {
        ArrayList<LinuxProcess> filtered = new ArrayList<LinuxProcess>();
        for (IProcess process : processes) {
            if (!(process instanceof LinuxProcess)) continue;
            filtered.add((LinuxProcess)process);
        }
        return (LinuxProcess[])filtered.toArray(LinuxProcess[]::new);
    }
}

