/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.process;

import com.gamedash.daemon.dependency.dependencies.LinuxProcessUsageDependency;
import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroup;
import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroups;
import com.gamedash.daemon.platform.linux.process.LinuxProcessDescendant;
import com.gamedash.daemon.platform.linux.process.LinuxProcessDescendants;
import com.gamedash.daemon.platform.linux.process.LinuxProcessException;
import com.gamedash.daemon.platform.linux.process.LinuxProcessHelper;
import com.gamedash.daemon.platform.linux.process.LinuxProcesses;
import com.gamedash.daemon.platform.linux.process.LinuxResourceLimitEnforcementManager;
import com.gamedash.daemon.platform.process.AbstractProcess;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.ProcessResourceUsageResult;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.resource.limit.IResourceLimitEnforcementManager;
import com.gamedash.daemon.process.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.system.hardware.processor.Processor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class LinuxProcess
extends AbstractProcess<LinuxProcess> {
    private final LinuxProcessDescendants descendants;
    private final String basePath = "/proc/" + this.getId();
    private LinuxCGroup cGroup;

    public LinuxProcess(int id) {
        super(id);
        this.descendants = new LinuxProcessDescendants(this);
    }

    @Override
    public String getName() throws Exception {
        return this.readProcStatusFile().get("Name");
    }

    @Override
    public String[] getCommandLine() throws Exception {
        try {
            return FileUtils.readFileToString(new File(this.basePath + "/cmdline"), StandardCharsets.UTF_8).split("\u0000");
        }
        catch (FileNotFoundException e) {
            throw new ProcessNotFoundException(this.getId());
        }
    }

    @Override
    public File getWorkingDirectory() throws Exception {
        return Files.readSymbolicLink(Paths.get(this.basePath + "/cwd", new String[0])).toFile();
    }

    @Override
    public void kill() throws Exception {
        this.kill("9");
    }

    @Override
    public void kill(String signal) throws Exception {
        LinuxProcesses.kill(new LinuxProcess[]{this}, signal);
    }

    @Override
    public void stop() throws Exception {
        LinuxProcesses.stop(new LinuxProcess[]{this});
    }

    @Override
    public boolean hasExited() throws Exception {
        if (this.exited != null) {
            return this.exited;
        }
        return !Paths.get(this.basePath, new String[0]).toFile().exists();
    }

    @Override
    public List<LinuxProcess> getChildren() throws Exception {
        return this.descendants.getAll().stream().map(LinuxProcessDescendant::getProcess).collect(Collectors.toList());
    }

    public Map<String, String> readProcStatusFile() throws Exception {
        try {
            List<String> lines = FileUtils.readLines(new File("/proc/" + this.getId() + "/status"), StandardCharsets.UTF_8);
            HashMap<String, String> output = new HashMap<String, String>();
            for (String line : lines) {
                String[] lineBits = line.split(":", 2);
                output.put(lineBits[0], lineBits[1].split("\\s+", 2)[1]);
            }
            return output;
        }
        catch (FileNotFoundException exception) {
            throw new ProcessNotFoundException(this.getId());
        }
    }

    @Override
    public ProcessResourceUsageResult getResourceUsage() throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn(LinuxProcessUsageDependency.getFile().getPath(), new String[]{"pid=" + this.getId()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new IOException("Query failed");
        }
        String result = childProcess.getIo().getOutputItems().get(0).getValue();
        String[] resultBits = result.split(",");
        return new ProcessResourceUsageResult(Integer.parseInt(resultBits[0].replaceAll("[^0-9.]", "")), Integer.parseInt(resultBits[1].replaceAll("[^0-9.]", "")));
    }

    @Override
    public void enforceResourceLimits() throws Exception {
        List<LinuxProcess> processes = this.descendants.getAll().stream().map(LinuxProcessDescendant::getProcess).collect(Collectors.toList());
        processes.add(this);
        this.enforceCPUResourceLimit(processes);
        this.enforceRAMResourceLimit();
        this.enforceDiskResourceLimit();
    }

    private void enforceCPUResourceLimit(List<LinuxProcess> processes) throws Exception {
        CPUResourceLimit cpu = this.getCPUResourceLimit();
        if (cpu != null) {
            if (cpu.getPercentage() != null) {
                this.enforceCPUPercentage();
            }
            if (cpu.getProcessorAffinity() != null) {
                this.enforceCPUProcessorAffinity();
            }
            if (cpu.getPriority() != null) {
                this.enforceCPUPriority(processes);
            }
        }
    }

    private void enforceCPUPercentage() throws Exception {
        CPUResourceLimit cpu = this.getCPUResourceLimit();
        LinuxCGroup cGroup = this.getCGroup();
        cGroup.getCPU().setPercentage(cpu.getPercentage() != null ? cpu.getPercentage().intValue() : cpu.getPercentageFromThreads());
        cGroup.getCPU().limitProcess(this);
    }

    private void enforceCPUProcessorAffinity() throws Exception {
        List<Processor> processors = this.getCPUResourceLimit().getProcessorAffinity();
        this.ensureAffinityProcessorsIsInRange(processors);
        ArrayList<LinuxProcess> processes = new ArrayList<LinuxProcess>();
        processes.add(this);
        processes.addAll(this.getChildren());
        try (ChildProcess childProcess = ChildProcesses.create();){
            childProcess.setIsSelfManaged(false);
            childProcess.setCanInterrupt(false);
            childProcess.spawn("for", new String[]{"pid", "in", processes.stream().map(process -> Long.toString(process.getId())).collect(Collectors.joining(" ")), ";", "do", "taskset", "-pca", processors.stream().map(processor -> String.valueOf(processor.getId())).collect(Collectors.joining(",")), "$pid", ";", "done"});
            childProcess.waitForExit();
            if (childProcess.getExitCode() != 0) {
                throw new LinuxProcessException("Could not set processor affinity");
            }
        }
    }

    private void enforceCPUPriority(List<LinuxProcess> processes) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        int nice = LinuxProcessHelper.getNice(this.getCPUResourceLimit().getPriority());
        childProcess.spawn("renice", new String[]{(nice > 0 ? "+" : "") + nice, processes.stream().map(process -> Long.toString(process.getId())).collect(Collectors.joining(" "))});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxProcessException("Could not set priority");
        }
    }

    public void enforceRAMResourceLimit() throws Exception {
        RAMResourceLimit ram = this.getRAMResourceLimit();
        if (ram == null || ram.getMB() != null) {
            return;
        }
        LinuxCGroup cGroup = this.getCGroup();
        if (ram.getMB() != null) {
            cGroup.getRAM().setMB(ram.getMB());
        }
        cGroup.getRAM().limitProcess(this);
    }

    public void enforceDiskResourceLimit() throws Exception {
        DiskResourceLimit disk = this.getDiskResourceLimit();
        if (disk == null || disk.getMBs() != null) {
            return;
        }
        LinuxCGroup cGroup = this.getCGroup();
        if (disk.getMBs() != null) {
            cGroup.getDisk().setMBs(disk.getMBs());
        }
        cGroup.getDisk().limitProcess(this);
    }

    @Override
    public void destroyResourceLimits() throws Exception {
        if (this.hasCGroup()) {
            this.getCGroup().delete();
        }
    }

    @Override
    protected IResourceLimitEnforcementManager createResourceLimitEnforcementManager() {
        return new LinuxResourceLimitEnforcementManager(this);
    }

    private LinuxCGroup getCGroup() throws Exception {
        if (this.cGroup == null) {
            this.cGroup = this.createCGroup();
        }
        return this.cGroup;
    }

    private boolean hasCGroup() {
        return this.cGroup != null;
    }

    private LinuxCGroup createCGroup() throws Exception {
        String name = RandomStringUtils.randomAlphanumeric(24);
        return LinuxCGroups.create(name);
    }

    public boolean equals(Object process) {
        return process instanceof IProcess && ((IProcess)process).getId() == this.getId();
    }
}

