/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.packageManager.packages.repository;

import com.gamedash.daemon.platform.linux.packageManager.packages.AlreadyPropagatingPackageInstallException;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.Distros;
import java.util.concurrent.locks.ReentrantLock;

public class LinuxPackageRepository {
    private static final ReentrantLock installPropagationLock = new ReentrantLock();
    private final String name;

    public LinuxPackageRepository(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void install() throws Exception {
        if (installPropagationLock.tryLock()) {
            try {
                Distros.getCurrent().installRepository(this);
            }
            finally {
                installPropagationLock.unlock();
            }
        } else {
            throw new AlreadyPropagatingPackageInstallException("Installation already propagating");
        }
    }

    public void uninstall() throws Exception {
        if (installPropagationLock.tryLock()) {
            try {
                Distros.getCurrent().uninstallRepository(this);
            }
            finally {
                installPropagationLock.unlock();
            }
        } else {
            throw new AlreadyPropagatingPackageInstallException("Installation already propagating");
        }
    }
}

