/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.packageManager.packages.distro;

import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.platform.linux.LinuxDistroEnum;
import com.gamedash.daemon.platform.linux.LinuxPlatform;
import com.gamedash.daemon.platform.linux.LinuxPlatformRelease;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.CentOSDistro;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.DebianDistro;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.IDistro;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.RHELDistro;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.UbuntuDistro;

public class Distros {
    private static final CachedValue<IDistro> distro = new CachedValue();

    public static IDistro getCurrent() throws Exception {
        return distro.handle(() -> {
            LinuxPlatformRelease distro = LinuxPlatform.getRelease();
            IDistro instance = null;
            if (distro.getDistro() == LinuxDistroEnum.centos) {
                instance = new CentOSDistro();
            } else if (distro.getDistro() == LinuxDistroEnum.rhel) {
                instance = new RHELDistro();
            } else if (distro.getDistro() == LinuxDistroEnum.debian) {
                instance = new DebianDistro();
            } else if (distro.getDistro() == LinuxDistroEnum.ubuntu) {
                instance = new UbuntuDistro();
            }
            return instance;
        });
    }
}

