/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.packageManager.packages.distro;

import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackage;
import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackageException;
import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackageNotFoundException;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.IDistro;
import com.gamedash.daemon.platform.linux.packageManager.packages.repository.LinuxPackageRepository;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class DebianDistro
implements IDistro {
    @Override
    public void install(LinuxPackage linuxPackage) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("apt-get", new String[]{"--yes", "--force-yes", "install", linuxPackage.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            if (childProcess.getExitCode() == 100) {
                throw new LinuxPackageNotFoundException("Package " + linuxPackage.getName() + " could not be found");
            }
            throw new LinuxPackageException("Could not install package");
        }
    }

    @Override
    public void uninstall(LinuxPackage linuxPackage) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("apt-get", new String[]{"--yes", "--force-yes", "remove", linuxPackage.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxPackageException("Could not uninstall package");
        }
    }

    @Override
    public void installRepository(LinuxPackageRepository linuxPackageRepository) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("add-apt-repository", new String[]{"--yes", "--force-yes", linuxPackageRepository.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxPackageException("Could not install repository");
        }
    }

    @Override
    public void uninstallRepository(LinuxPackageRepository linuxPackageRepository) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.setCanInterrupt(true);
        childProcess.spawn("add-apt-repository", new String[]{"--yes", "--force-yes", "--remove", linuxPackageRepository.getName()});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxPackageException("Could not uninstall repository");
        }
    }
}

