/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.packageManager.packages;

import com.gamedash.daemon.platform.linux.packageManager.packages.AlreadyPropagatingPackageInstallException;
import com.gamedash.daemon.platform.linux.packageManager.packages.distro.Distros;
import java.util.concurrent.locks.ReentrantLock;

public class LinuxPackage {
    private static final ReentrantLock installPropagationLock = new ReentrantLock();
    private final String name;

    public LinuxPackage(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void install() throws Exception {
        if (installPropagationLock.tryLock()) {
            try {
                Distros.getCurrent().install(this);
            }
            finally {
                installPropagationLock.unlock();
            }
        } else {
            throw new AlreadyPropagatingPackageInstallException("Installation already propagating");
        }
    }

    public void uninstall() throws Exception {
        if (installPropagationLock.tryLock()) {
            try {
                Distros.getCurrent().uninstall(this);
            }
            finally {
                installPropagationLock.unlock();
            }
        } else {
            throw new AlreadyPropagatingPackageInstallException("Installation already propagating");
        }
    }
}

