/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.cgroup;

import com.gamedash.daemon.platform.linux.cgroup.LinuxCGroupException;
import com.gamedash.daemon.platform.linux.cgroup.resource.IResource;
import com.gamedash.daemon.platform.linux.process.LinuxProcess;
import com.gamedash.daemon.process.IProcess;
import java.util.ArrayList;
import java.util.List;

public class LinuxCGroupProcess
extends LinuxProcess {
    private List<IResource> limitedResources = new ArrayList<IResource>();

    public LinuxCGroupProcess(IProcess process) {
        super(process.getId());
    }

    public List<IResource> getLimitedResources() {
        return this.limitedResources;
    }

    public boolean resourceIsLimited(IResource resource) {
        return this.limitedResources.contains(resource);
    }

    public void addLimitedResource(IResource resource) throws LinuxCGroupException {
        if (this.resourceIsLimited(resource)) {
            throw new LinuxCGroupException("Resource " + resource.getClass().getName() + " already limited");
        }
        this.limitedResources.add(resource);
    }

    public void removeLimitedResource(IResource resource) throws LinuxCGroupException {
        if (!this.resourceIsLimited(resource)) {
            throw new LinuxCGroupException("Resource " + resource.getClass().getName() + " not limited");
        }
        this.limitedResources.remove(resource);
    }
}

