/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation;

import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.platform.PlatformException;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotRunningException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildProcessesInitializer
extends InitializerImplementation {
    private static final Logger logger = LoggerFactory.getLogger(ChildProcessesInitializer.class);

    @Override
    public void initialize() throws Exception {
        super.initialize();
        List<IProcess<?>> floatingProcessesDestroyed = this.destroyFloatingChildProcesses();
        if (floatingProcessesDestroyed.size() > 0) {
            logger.info(MessageFormat.format("Destroyed {0,number,#} floating child {1}", floatingProcessesDestroyed.size(), floatingProcessesDestroyed.size() > 1 ? "processes" : "process"));
        }
    }

    @Override
    public void destroy() throws Exception {
        if (ChildProcesses.childProcessesAreManaged()) {
            List<ChildProcess> processes = this.destroyRunningProcesses();
            logger.info(MessageFormat.format("Destroyed {0,number,#} running child processes", processes.size()));
        }
        super.destroy();
    }

    private List<IProcess<?>> destroyFloatingChildProcesses() throws Exception {
        List<IProcess<?>> processes = ChildProcesses.getFloating();
        for (IProcess<?> process : processes) {
            try {
                block6: {
                    try {
                        if (!process.hasExited()) {
                            process.kill("-9");
                        }
                    }
                    catch (PlatformException | ProcessException e) {
                        if (!DevelopmentMode.isEnabled()) break block6;
                        logger.error(ExceptionUtils.getStackTrace(e));
                    }
                }
                ChildProcesses.getRegistry().removeEntry(process.getId());
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
        return processes;
    }

    private List<ChildProcess> destroyRunningProcesses() throws Exception {
        List<ChildProcess> running = ChildProcesses.getRunning();
        if (running.size() > 0) {
            ArrayList<ChildProcess> processesToAwaitExit = new ArrayList<ChildProcess>();
            for (ChildProcess childProcess : running) {
                try {
                    if (childProcess.canInterrupt()) {
                        childProcess.stop();
                        continue;
                    }
                    processesToAwaitExit.add(childProcess);
                }
                catch (ChildProcessNotRunningException childProcessNotRunningException) {
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }
            for (ChildProcess childProcess : processesToAwaitExit) {
                childProcess.waitForExit();
            }
        }
        return running;
    }
}

