/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.infrastructure.node.self.status;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.infrastructure.node.self.status.handshake.session.StatusHandshakeSession;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.schokkerit.restapi.client.response.IQueryResponseErrorHandlerCallback;

public class StatusUpdateQuery {
    private final ApiQuery query;
    private final boolean isOnline;
    private StatusHandshakeSession handshakeSession;

    public StatusUpdateQuery(boolean isOnline) throws Exception {
        this.isOnline = isOnline;
        this.query = this.createQuery();
    }

    public void send() throws Exception {
        StatusHandshakeSession session = this.getHandshakeSession();
        if (session != null) {
            this.query.getParameters().create("handshake_session_id", session.getId());
        }
        this.query.put();
    }

    public void registerErrorHandler(IQueryResponseErrorHandlerCallback<QueryResponse> handler) {
        this.query.getResponseErrorHandlerManager().registerHandler(handler);
    }

    public StatusHandshakeSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public void setHandshakeSession(StatusHandshakeSession session) {
        this.handshakeSession = session;
    }

    private ApiQuery createQuery() throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/status/isonline");
        query.getParameters().create("isOnline", this.isOnline);
        query.getParameters().create("childProcessesAreManaged", ChildProcesses.childProcessesAreManaged());
        return query;
    }

    public static StatusUpdateQuery create(boolean isOnline) throws Exception {
        return new StatusUpdateQuery(isOnline);
    }
}

