/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.fileSystem.remote.host;

import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.fileSystem.remote.host.RemoteFileSystemHosts;
import com.gamedash.daemon.fileSystem.remote.host.implementation.IRemoteFileSystemHostImplementation;
import com.gamedash.daemon.fileSystem.remote.user.session.RemoteFileSystemUserSession;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.List;

public class RemoteFileSystemHost {
    private final Class<?> implementationClass;
    private final InetAddress ipAddress;
    private final int port;
    private final boolean isSecure;
    private final CachedValue<IRemoteFileSystemHostImplementation> instance = new CachedValue();

    public RemoteFileSystemHost(Class<?> implementationClass, InetAddress ipAddress, int port, boolean isSecure) {
        this.implementationClass = implementationClass;
        this.ipAddress = ipAddress;
        this.port = port;
        this.isSecure = isSecure;
    }

    public void start() throws Exception {
        this.getInstance().start();
        RemoteFileSystemHosts.addRunning(this);
    }

    public void stop() throws Exception {
        this.getInstance().stop();
        RemoteFileSystemHosts.removeRunning(this);
    }

    public boolean isRunning() {
        return RemoteFileSystemHosts.implementationIsRunning(this);
    }

    public List<RemoteFileSystemUserSession> getSessions() throws Exception {
        return this.getInstance().getSessions();
    }

    public void disconnectSession(RemoteFileSystemUserSession session) throws Exception {
        this.getInstance().disconnectSession(session);
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private IRemoteFileSystemHostImplementation getInstance() throws Exception {
        return this.instance.handle(() -> {
            Constructor<?> constructor = this.implementationClass.getConstructor(new Class[0]);
            IRemoteFileSystemHostImplementation instance = (IRemoteFileSystemHostImplementation)constructor.newInstance(new Object[0]);
            instance.setPort(this.getPort());
            return instance;
        });
    }
}

