/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.repository.image;

import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.implementation.interfaces.repository.image.IDockerRepositoryImageImpl;
import com.gamedash.daemon.docker.implementation.interfaces.repository.image.IDockerRepositoryImagesImpl;
import com.gamedash.daemon.docker.repository.DockerRepository;
import com.gamedash.daemon.docker.repository.image.DockerRepositoryImage;
import java.util.List;
import java.util.stream.Collectors;

public class DockerRepositoryImages {
    private final Docker docker;
    private final DockerRepository repository;
    private final IDockerRepositoryImagesImpl implementation;

    public DockerRepositoryImages(Docker docker, DockerRepository repository, IDockerRepositoryImagesImpl implementation) {
        this.docker = docker;
        this.repository = repository;
        this.implementation = implementation;
    }

    public List<DockerRepositoryImage> getByTag(String tag) {
        List<IDockerRepositoryImageImpl> implementations = this.implementation.getByTag(tag);
        return implementations.stream().map(this::createInstance).collect(Collectors.toList());
    }

    public void pull() throws Exception {
        this.pull(null);
    }

    public void pull(String tag) throws Exception {
        this.implementation.pull(tag);
    }

    private DockerRepositoryImage createInstance(IDockerRepositoryImageImpl implementation) {
        return new DockerRepositoryImage(this.docker, this.repository, implementation);
    }
}

