/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.interfaces.container.crash.report;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerImpl;
import com.gamedash.daemon.process.crash.report.CrashReport;
import com.gamedash.daemon.process.crash.report.CrashReportProcessPropagatingException;
import com.gamedash.daemon.process.crash.report.ICrashReportSender;

public class DockerContainerCrashReportSender
implements ICrashReportSender {
    private final IDockerContainerImpl container;

    public DockerContainerCrashReportSender(IDockerContainerImpl container) {
        this.container = container;
    }

    @Override
    public void send(CrashReport report) throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/docker/container/" + this.container.getId() + "/crash/report");
        query.getResponseErrorHandlerManager().registerHandler(response -> {
            if (response.getErrorCode().equals("NOT_CRASHED")) {
                throw new CrashReportProcessPropagatingException("Process does not appear to have crashed");
            }
        });
        query.post();
    }
}

