/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container.io;

import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.container.io.DockerContainerIOOutputItem;
import com.gamedash.daemon.docker.container.io.IDockerContainerIOErrorCallback;
import com.gamedash.daemon.docker.container.io.IDockerContainerIOOutputCallback;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoErrorListener;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoOutputListener;
import com.gamedash.daemon.docker.implementation.generic.container.io.ListenTypeEnum;
import com.gamedash.daemon.docker.implementation.generic.container.io.ResultCallback;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Frame;
import java.util.concurrent.atomic.AtomicInteger;

public class DockerContainerIoListener {
    private final DockerImpl docker;
    private final DockerContainerImpl container;
    private final DockerContainerIoOutputListener onIoOutputListener = new DockerContainerIoOutputListener();
    private final DockerContainerIoErrorListener onIoErrorListener = new DockerContainerIoErrorListener();
    private ResultCallback outputListenerHandle;
    private ResultCallback errorListenerHandle;

    public DockerContainerIoListener(DockerImpl docker, DockerContainerImpl container) {
        this.docker = docker;
        this.container = container;
    }

    public void listen() throws Exception {
        final AtomicInteger outputIndex = new AtomicInteger(0);
        final DockerContainerIoListener self = this;
        this.outputListenerHandle = this.listenForIoType(ListenTypeEnum.standard, new ResultCallback(){

            @Override
            public void onNext(Frame frame) {
                int incrementedOutputIndex = outputIndex.incrementAndGet();
                DockerContainerIOOutputItem item = DockerContainerIOOutputItem.create(new String(frame.getPayload()));
                item.setIndex(incrementedOutputIndex);
                self.onIoOutputListener.invokeAsync(item);
            }

            @Override
            public void onError(Throwable throwable) {
                self.onIoErrorListener.invokeAsync(throwable);
            }
        });
        this.errorListenerHandle = this.listenForIoType(ListenTypeEnum.error, new ResultCallback(){

            @Override
            public void onNext(Frame frame) {
                int incrementedOutputIndex = outputIndex.incrementAndGet();
                DockerContainerIOOutputItem item = DockerContainerIOOutputItem.create(new String(frame.getPayload()), true);
                item.setIndex(incrementedOutputIndex);
                self.onIoOutputListener.invokeAsync(item);
            }

            @Override
            public void onError(Throwable throwable) {
                self.onIoErrorListener.invokeAsync(throwable);
            }
        });
    }

    public void destroy() throws Exception {
        if (this.outputListenerHandle != null) {
            this.outputListenerHandle.close();
        }
        if (this.outputListenerHandle != null) {
            this.errorListenerHandle.close();
        }
    }

    private ResultCallback listenForIoType(ListenTypeEnum type, ResultCallback resultCallback) {
        DockerContainerIoListener dockerContainerIoListener = this;
        LogContainerCmd cmd = dockerContainerIoListener.docker.getClient().logContainerCmd(this.container.getId()).withStdOut(type == ListenTypeEnum.standard).withStdErr(type == ListenTypeEnum.error).withSince((int)Time.now().getTimestamp()).withFollowStream(true);
        return cmd.exec(resultCallback);
    }

    public void onOutput(IDockerContainerIOOutputCallback callback) {
        this.onIoOutputListener.addCallback(callback);
    }

    public void onError(IDockerContainerIOErrorCallback callback) {
        this.onIoErrorListener.addCallback(callback);
    }
}

