/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container.io;

import com.gamedash.daemon.common.listener.ListenerCallbackHandle;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.container.io.DockerContainerIOOutputItem;
import com.gamedash.daemon.docker.container.io.IDockerContainerIOErrorCallback;
import com.gamedash.daemon.docker.container.io.IDockerContainerIOOutputCallback;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoErrorListener;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoListener;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoOutputListener;
import com.gamedash.daemon.docker.implementation.interfaces.container.io.AbstractDockerContainerIoImpl;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AttachContainerCmd;
import com.github.dockerjava.api.command.LogContainerCmd;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.command.LogContainerResultCallback;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerIoImpl
extends AbstractDockerContainerIoImpl {
    private static final Logger logger = LoggerFactory.getLogger(DockerContainerIoImpl.class);
    private final DockerImpl docker;
    private final DockerContainerImpl container;
    private final DockerContainerIoOutputListener onIoOutputListener = new DockerContainerIoOutputListener();
    private final DockerContainerIoErrorListener onIoErrorListener = new DockerContainerIoErrorListener();
    private final DockerContainerIoListener listener;
    private PipedInputStream inputStream;
    private PipedOutputStream outputStream;
    private ResultCallback.Adapter<Frame> streamHandler;
    private boolean isListening = false;
    private boolean isAttached = false;

    public DockerContainerIoImpl(DockerImpl docker, DockerContainerImpl container) {
        this.docker = docker;
        this.container = container;
        this.listener = new DockerContainerIoListener(docker, container);
        this.listener.onOutput(this.onIoOutputListener::invokeAsync);
        this.listener.onError(this.onIoErrorListener::invokeAsync);
    }

    @Override
    public ListenerCallbackHandle<IDockerContainerIOOutputCallback> onOutput(IDockerContainerIOOutputCallback callback) {
        return this.onIoOutputListener.addCallback(callback);
    }

    @Override
    public ListenerCallbackHandle<IDockerContainerIOErrorCallback> onError(IDockerContainerIOErrorCallback callback) {
        return this.onIoErrorListener.addCallback(callback);
    }

    @Override
    public List<DockerContainerIOOutputItem> getOutput() throws Exception {
        return this.getOutput(null);
    }

    @Override
    public List<DockerContainerIOOutputItem> getOutput(Integer tail) throws Exception {
        final ArrayList<DockerContainerIOOutputItem> output = new ArrayList<DockerContainerIOOutputItem>();
        LogContainerCmd cmd = DockerImpl.getClient().logContainerCmd(this.container.getId());
        cmd.withStdOut(true);
        cmd.withStdErr(true);
        Time timeStarted = this.container.getTimeStarted();
        if (timeStarted != null) {
            cmd.withSince((int)timeStarted.getTimestamp());
        }
        if (tail != null) {
            cmd.withTail(tail);
        }
        cmd.exec(new LogContainerResultCallback(){

            @Override
            public void onNext(Frame frame) {
                DockerContainerIOOutputItem item = DockerContainerIOOutputItem.create(frame.toString());
                item.setIndex(output.size());
                output.add(item);
            }
        }).awaitCompletion();
        return output;
    }

    @Override
    public void sendInput(String input) throws Exception {
        this.ensureIsAttached();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream());
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(input + "\r\n");
            bufferedWriter.flush();
        }
        catch (IOException e) {
            this.reAttachStream();
            this.sendInput(input);
        }
    }

    @Override
    public synchronized void attach() throws Exception {
        if (this.isAttached()) {
            return;
        }
        this.attachStream();
        this.attachListener();
        if (!this.isListening()) {
            this.listen();
        }
        this.setIsAttached(true);
    }

    @Override
    public void ensureIsAttached() throws Exception {
        if (!this.isAttached()) {
            this.attach();
        }
    }

    @Override
    public void destroy() throws Exception {
        if (!this.isAttached()) {
            return;
        }
        this.destroyStream();
        if (this.isListening()) {
            this.destroyListener();
        }
        this.setIsAttached(false);
    }

    private synchronized void listen() throws Exception {
        if (this.isListening()) {
            throw new RuntimeException("Already listening");
        }
        this.listener.listen();
        this.setIsListening(true);
    }

    protected void destroyListener() throws Exception {
        if (!this.isListening()) {
            throw new RuntimeException("Not listening");
        }
        this.detachListener();
        this.listener.destroy();
        this.setIsListening(false);
    }

    private boolean isListening() {
        return this.isListening;
    }

    private void setIsListening(boolean listening) {
        this.isListening = listening;
    }

    private synchronized void reAttachStream() throws Exception {
        this.destroyStream();
        this.attachStream();
    }

    private void attachStream() {
        Thread thread = new Thread(() -> {
            try {
                PipedOutputStream pipedOutputStream;
                this.outputStream = pipedOutputStream = new PipedOutputStream();
                this.inputStream = new PipedInputStream(pipedOutputStream);
                AttachContainerCmd attachContainerCmd = DockerImpl.getClient().attachContainerCmd(this.container.getId()).withStdIn(this.inputStream).withStdOut(true).withStdErr(true).withTimestamps(true).withFollowStream(true);
                this.streamHandler = attachContainerCmd.exec(new ResultCallback.Adapter());
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.setName(String.format("IO listener for Docker container %s", this.container.getId()));
        thread.start();
    }

    private void destroyStream() throws Exception {
        this.getOutputStream().close();
        this.getInputStream().close();
        this.streamHandler.close();
    }

    private PipedInputStream getInputStream() {
        return this.inputStream;
    }

    private PipedOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isAttached() {
        return this.isAttached;
    }

    private void setIsAttached(boolean attached) {
        this.isAttached = attached;
    }
}

