/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic;

import com.gamedash.daemon.docker.implementation.generic.container.DockerContainersImpl;
import com.gamedash.daemon.docker.implementation.generic.image.DockerImagesImpl;
import com.gamedash.daemon.docker.implementation.generic.repository.DockerRepositoriesImpl;
import com.gamedash.daemon.docker.implementation.interfaces.IDockerImpl;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;

public class DockerImpl
implements IDockerImpl {
    private static DockerClient client;
    private final DockerContainersImpl containers = new DockerContainersImpl(this);
    private final DockerRepositoriesImpl repositories = new DockerRepositoriesImpl(this);
    private final DockerImagesImpl images = new DockerImagesImpl(this);

    @Override
    public boolean isRunning() {
        try {
            DockerImpl.getClient().pingCmd().exec();
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public DockerContainersImpl getContainers() {
        return this.containers;
    }

    @Override
    public DockerRepositoriesImpl getRepositories() {
        return this.repositories;
    }

    @Override
    public DockerImagesImpl getImages() {
        return this.images;
    }

    public static synchronized DockerClient getClient() {
        if (client == null) {
            client = DockerImpl.createClient();
        }
        return client;
    }

    public static DockerClient createClient() {
        DockerClientConfig config = DockerImpl.createConfig();
        DockerHttpClient httpClient = DockerImpl.createHttpClient(config);
        return DockerClientImpl.getInstance(config, httpClient);
    }

    public static DockerHttpClient createHttpClient(DockerClientConfig config) {
        return new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig(config.getSSLConfig()).maxConnections(99999).build();
    }

    public static DockerClientConfig createConfig() {
        DefaultDockerClientConfig.Builder config = DefaultDockerClientConfig.createDefaultConfigBuilder();
        return config.build();
    }
}

