/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container.io;

import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.io.DockerContainerIOOutputItem;
import com.gamedash.daemon.docker.container.io.IDockerContainerIOErrorCallback;
import com.gamedash.daemon.docker.container.io.IDockerContainerIOOutputCallback;
import com.gamedash.daemon.docker.container.io.listener.IDockerContainerIOListener;
import java.lang.reflect.Constructor;
import java.util.List;

public class DockerContainerIO {
    private final DockerContainer container;

    public DockerContainerIO(DockerContainer container) {
        this.container = container;
    }

    public void sendInput(String input) throws Exception {
        this.container.getImplementation().getIo().sendInput(input);
    }

    public List<DockerContainerIOOutputItem> getOutput() throws Exception {
        return this.container.getImplementation().getIo().getOutput();
    }

    public List<DockerContainerIOOutputItem> getOutput(Integer tail) throws Exception {
        return this.container.getImplementation().getIo().getOutput(tail);
    }

    public void onOutput(IDockerContainerIOOutputCallback callback) {
        this.container.getImplementation().getIo().onOutput(callback);
    }

    public void onError(IDockerContainerIOErrorCallback callback) {
        this.container.getImplementation().getIo().onError(callback);
    }

    public void attach() throws Exception {
        this.container.getImplementation().getIo().attach();
    }

    public boolean isAttached() {
        return this.container.getImplementation().getIo().isAttached();
    }

    public void ensureIsAttached() throws Exception {
        this.container.getImplementation().getIo().ensureIsAttached();
    }

    public void destroy() throws Exception {
        this.container.getImplementation().getIo().destroy();
    }

    public List<IDockerContainerIOListener> getListeners() {
        return this.container.getImplementation().getIo().getListeners();
    }

    public <T extends IDockerContainerIOListener> T getListener(Class<T> clazz) {
        for (IDockerContainerIOListener listener : this.getListeners()) {
            if (listener.getClass() != clazz) continue;
            return (T)listener;
        }
        return null;
    }

    public boolean hasListener(Class<? extends IDockerContainerIOListener> clazz) {
        return this.getListener(clazz) != null;
    }

    public <T extends IDockerContainerIOListener> T acquireListener(Class<T> clazz) throws Exception {
        T listener = this.getListener(clazz);
        if (listener == null) {
            listener = this.createListenerInstance(clazz);
            this.addListener((IDockerContainerIOListener)listener);
        }
        return listener;
    }

    public void addListener(IDockerContainerIOListener listener) {
        this.container.getImplementation().getIo().addListener(listener);
    }

    private <T extends IDockerContainerIOListener> T createListenerInstance(Class<T> clazz) throws Exception {
        Constructor<T> constructor = clazz.getConstructor(DockerContainer.class);
        return (T)((IDockerContainerIOListener)constructor.newInstance(this.container));
    }
}

