/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency.install;

import com.gamedash.daemon.dependency.Dependencies;
import com.gamedash.daemon.dependency.Dependency;
import com.gamedash.daemon.dependency.DependencyElevatedPermissionException;
import com.gamedash.daemon.dependency.install.IInstallerManagerProgressCallback;
import com.gamedash.daemon.dependency.install.InstallerManagerProgressListener;
import com.gamedash.daemon.permission.Permissions;

public class InstallManager {
    private final Dependency dependency;
    private final InstallerManagerProgressListener installProgressListener = new InstallerManagerProgressListener();
    private final InstallerManagerProgressListener uninstallProgressListener = new InstallerManagerProgressListener();

    public InstallManager(Dependency dependency) {
        this.dependency = dependency;
    }

    public void install() throws Exception {
        if (this.dependency.isInstalled()) {
            throw new Exception("Dependency " + this.dependency.getName() + " is already installed");
        }
        if (this.dependency.requiresElevatedPermissions() && !Permissions.isRunningWithElevatedPermissions()) {
            throw new DependencyElevatedPermissionException("Installation of dependency " + this.dependency.getName() + " requires the daemon to be running with elevated permissions");
        }
        this.dependency.getInstance().install(this.installProgressListener::invoke);
        Dependencies.addInstalled(this.dependency);
    }

    public void uninstall() throws Exception {
        if (!this.dependency.isInstalled()) {
            throw new Exception("Dependency " + this.dependency.getName() + " is not installed");
        }
        this.dependency.getInstance().uninstall(this.uninstallProgressListener::invoke);
        Dependencies.removeInstalled(this.dependency);
    }

    public void onInstallProgress(IInstallerManagerProgressCallback callback) {
        this.installProgressListener.addCallback(callback::invoke);
    }

    public void onUninstallProgress(IInstallerManagerProgressCallback callback) {
        this.uninstallProgressListener.addCallback(callback::invoke);
    }
}

