/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.security.keyStore;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStore {
    public static File getFile() throws Exception {
        if (!KeyStore.hasFile().booleanValue()) {
            throw new KeyStoreException("No keystore file is set");
        }
        Path path = Paths.get(Config.getDefaultFile().getValue("security.keystore.file"), new String[0]);
        if (path.isAbsolute()) {
            return path.toFile();
        }
        return new File(FileSystem.getRootDirectory().getAbsolutePath() + File.separator + path);
    }

    public static Boolean hasFile() throws Exception {
        return Config.getDefaultFile().valueExists("security.keystore.file");
    }

    public static void setFile(File file) throws Exception {
        Config.getDefaultFile().setValue("security.keystore.file", file.getPath());
    }

    public static String getPassword() throws Exception {
        if (!KeyStore.hasPassword()) {
            throw new KeyStoreException("No keystore password is set");
        }
        return Config.getDefaultFile().getValue("security.keystore.password");
    }

    public static boolean hasPassword() throws Exception {
        return Config.getDefaultFile().valueExists("security.keystore.password");
    }

    public static void setPassword(String password) throws Exception {
        Config.getDefaultFile().setValue("security.keystore.password", password);
    }

    public static boolean validatePassword(String password) throws Exception {
        return KeyStore.validatePassword(KeyStore.getFile(), password);
    }

    public static boolean validatePassword(File file, String password) throws IOException, SecurityException, KeyStoreException {
        java.security.KeyStore keyStore = java.security.KeyStore.getInstance(java.security.KeyStore.getDefaultType());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore.load(fileInputStream, password.toCharArray());
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            return false;
        }
        return true;
    }

    public static Boolean isSelfSigned() throws Exception {
        return Config.getDefaultFile().valueExists("security.keystore.isSelfSigned") && Config.getDefaultFile().getValue("security.keystore.isSelfSigned", Boolean.class) != false;
    }

    public static void setIsSelfSigned(boolean isSelfSigned) throws Exception {
        Config.getDefaultFile().setValue("security.keystore.isSelfSigned", isSelfSigned);
    }
}

