/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.listener;

import com.corundumstudio.socketio.SocketIOClient;
import com.gamedash.daemon.common.relay.payload.RelayErrorPayload;
import com.gamedash.daemon.common.relay.payload.RelaySuccessPayload;
import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import com.gamedash.daemon.common.relay.server.listener.IListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AddChannelListener
implements IListener {
    private final RelayServer server;

    public AddChannelListener(RelayServer server) {
        this.server = server;
    }

    @Override
    public void listen() {
        this.server.getApi().addEventListener("addChannel", AddChannelInput.class, (socketIoClient, input, ackSender) -> {
            final String channelName = input.getName();
            AddChannelsResult result = this.addToChannels(socketIoClient, (List<String>)new ArrayList<String>(){
                {
                    this.add(channelName);
                }
            });
            if (!result.addedChannelNames.contains(channelName)) {
                ackSender.sendAckData(new RelayErrorPayload("Already added to channel " + channelName));
            } else {
                ackSender.sendAckData(new RelaySuccessPayload("Successfully added to channel " + channelName));
            }
        });
        this.server.getApi().addEventListener("addChannels", AddChannelsInput.class, (socketIoClient, input, ackSender) -> {
            List<String> channelNames = input.getNames();
            AddChannelsResult result = this.addToChannels(socketIoClient, channelNames);
            ackSender.sendAckData(new RelaySuccessPayload("Successfully added to channels " + String.join((CharSequence)", ", result.addedChannelNames)));
        });
    }

    private AddChannelsResult addToChannels(SocketIOClient socketIoClient, List<String> channelNames) {
        List channels = channelNames.stream().map(channelName -> this.server.getChannels().acquire((String)channelName)).collect(Collectors.toList());
        AddChannelsResult result = new AddChannelsResult();
        RelayClient client = this.server.getClients().get(socketIoClient.getSessionId());
        for (RelayChannel channel : channels) {
            if (channel.getClients().has(client.getId())) continue;
            channel.getClients().add(client);
            result.addChannelName(channel.getName());
        }
        return result;
    }

    public static class AddChannelsResult {
        public List<String> addedChannelNames = new ArrayList<String>();

        public void addChannelName(String name) {
            this.addedChannelNames.add(name);
        }
    }

    public static class AddChannelsInput {
        private List<String> names;

        public List<String> getNames() {
            return this.names;
        }
    }

    public static class AddChannelInput {
        private String name;

        public String getName() {
            return this.name;
        }
    }
}

