/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.channel;

import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.channel.RelayChannelAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class RelayChannels {
    private final RelayServer server;
    private final Map<String, RelayChannel> channels = new ConcurrentHashMap<String, RelayChannel>();

    public RelayChannels(RelayServer server) {
        this.server = server;
    }

    public List<RelayChannel> getAll() {
        return new ArrayList<RelayChannel>(this.channels.values());
    }

    public synchronized RelayChannel create(String name) {
        if (this.exists(name)) {
            throw new RelayChannelAlreadyExistsException(String.format("Relay channel %s already exists", name));
        }
        RelayChannel channel = this.createInstance(name);
        this.channels.put(name, channel);
        return channel;
    }

    public synchronized RelayChannel acquire(String name) {
        try {
            return this.create(name);
        }
        catch (RelayChannelAlreadyExistsException relayChannelAlreadyExistsException) {
            return this.get(name).orElseThrow();
        }
    }

    public Optional<RelayChannel> get(String name) {
        return Optional.of(this.channels.get(name));
    }

    public void delete(String name) {
        this.channels.remove(name);
    }

    public boolean exists(String name) {
        return this.channels.containsKey(name);
    }

    private RelayChannel createInstance(String name) {
        return new RelayChannel(this.server, name);
    }
}

