/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.server.exception;

import com.gamedash.daemon.common.api.server.ApiServerException;
import com.gamedash.daemon.common.api.server.exception.ExceptionContainer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonExceptionSerializer
implements JsonSerializer<ExceptionContainer> {
    @Override
    public JsonElement serialize(ExceptionContainer container, Type typeOfSrc, JsonSerializationContext context) {
        Exception exception = container.getException();
        String code = GsonExceptionSerializer.getCodeFromContainer(container);
        JsonObject jsonRootObject = new JsonObject();
        jsonRootObject.add("message", new JsonPrimitive(exception.getMessage()));
        JsonArray jsonStacktraceElementArray = new JsonArray();
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            jsonStacktraceElementArray.add(stackTraceElement.toString());
        }
        jsonRootObject.add("stackTrace", jsonStacktraceElementArray);
        if (code != null) {
            jsonRootObject.add("code", new JsonPrimitive(code));
        }
        return jsonRootObject;
    }

    private static String getCodeFromContainer(ExceptionContainer container) {
        Exception exception = container.getException();
        if (exception instanceof ApiServerException && ((ApiServerException)exception).hasCode()) {
            return ((ApiServerException)exception).getCode();
        }
        return container.getCode();
    }
}

