/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.server.exception;

import com.gamedash.daemon.common.api.server.ApiServer;
import com.gamedash.daemon.common.api.server.exception.ExceptionContainer;
import com.gamedash.daemon.common.api.server.exception.ExceptionSerializer;
import com.gamedash.daemon.common.api.server.exception.IExceptionHandlerCallback;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.session.Session;
import com.gamedash.daemon.common.api.server.session.Sessions;

public class ExceptionHandler<T extends Exception> {
    private final Class<T> type;
    private ApiServer server;
    private IExceptionHandlerCallback callback;

    public ExceptionHandler(Class<T> type) {
        this.type = type;
        this.callback = (request, response, exception) -> response.setBody(ExceptionSerializer.serialize(ExceptionContainer.create(exception)));
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int httpStatusCode) {
        this.server = server;
        this.type = type;
        this.callback = (request, response, exception) -> {
            response.setStatusCode(httpStatusCode);
            response.setBody(ExceptionSerializer.serialize(ExceptionContainer.create(exception)));
        };
    }

    public ExceptionHandler(ApiServer server, Class<T> type, int httpStatusCode, String code) {
        this.server = server;
        this.type = type;
        this.callback = (request, response, exception) -> {
            response.setStatusCode(httpStatusCode);
            response.setBody(ExceptionSerializer.serialize(ExceptionContainer.create(exception, code)));
        };
    }

    public ExceptionHandler(ApiServer server, Class<T> type, IExceptionHandlerCallback callback) {
        this.server = server;
        this.type = type;
        this.callback = callback;
    }

    public void register() {
        this.server.getService().exception(this.type, (exception, sparkRequest, sparkResponse) -> {
            sparkResponse.type("application/json");
            Session session = Sessions.getSessionBySparkRequest(sparkRequest);
            Response response = session.getResponse();
            Request request = session.getRequest();
            this.callback.invoke(request, response, exception);
        });
    }
}

