/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.client;

import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.common.api.client.response.listener.IQueryResponseListenerCallback;
import com.gamedash.daemon.common.api.client.response.listener.QueryResponseListener;
import com.gamedash.daemon.common.authentication.Authentication;

public class ApiClient {
    private static final QueryResponseListener listener = new QueryResponseListener();

    public static ApiQuery createQuery(String endpoint) throws Exception {
        ApiQuery query = new ApiQuery(endpoint);
        query.getHeaders().create("daemon-token", Authentication.getCurrentToken().toString());
        return query;
    }

    public static ApiQuery createQueryWithoutAuthentication(String endpoint) throws Exception {
        return new ApiQuery(endpoint);
    }

    public static void onResponse(IQueryResponseListenerCallback callback) {
        listener.addCallback(callback);
    }

    public static void invokeOnResponse(ApiQuery query, QueryResponse response) {
        listener.invoke(query, response);
    }
}

