/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.system.OperatingSystem;
import com.google.gson.annotations.SerializedName;
import oshi.SystemInfo;
import oshi.hardware.Sensors;

public class GetStatistics
extends Route<Result> {
    private final SystemInfo systemInfo = new SystemInfo();

    public GetStatistics(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        return this.collect();
    }

    private Result collect() {
        if (OperatingSystem.isLinux()) {
            Sensors sensors = this.systemInfo.getHardware().getSensors();
            Result result = new Result();
            result.cpuTemperature = sensors.getCpuTemperature();
            result.cpuVoltage = sensors.getCpuVoltage();
            result.fanSpeeds = sensors.getFanSpeeds();
            return result;
        }
        return new Result();
    }

    static class Result {
        @SerializedName(value="cpuTemperature")
        public double cpuTemperature;
        @SerializedName(value="cpuVoltage")
        public double cpuVoltage;
        @SerializedName(value="fanSpeeds")
        public int[] fanSpeeds;

        Result() {
        }
    }
}

