/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.relay.server.channel;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import com.gamedash.daemon.relay.server.RelayServer;
import com.gamedash.daemon.relay.server.RelayServerInstanceNotFoundException;
import com.gamedash.daemon.relay.server.RelayServers;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.stream.Collectors;

public class GetAllChannels
extends Route<List<ChannelResult>> {
    public GetAllChannels(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<ChannelResult> execute() throws Exception {
        String id = this.request.getInput().getParameters().get("instance_id").getValue();
        RelayServer server = RelayServers.getInstanceById(id);
        return server.getChannels().getAll().stream().map(ChannelResult::new).collect(Collectors.toList());
    }

    @Override
    public void before() throws RequestParameterException {
        String id = this.request.getInput().getParameters().get("instance_id").getValue();
        if (RelayServers.getInstanceById(id) == null) {
            throw new RelayServerInstanceNotFoundException("Instance " + id + " not found");
        }
    }

    protected static class ChannelResult {
        @SerializedName(value="name")
        private final String name;
        @SerializedName(value="clients")
        private final List<ClientResult> clients;

        public ChannelResult(RelayChannel channel) {
            this.name = channel.getName();
            this.clients = channel.getClients().getAll().stream().map(ClientResult::new).collect(Collectors.toList());
        }

        public String[] getRequiredParameters() {
            return new String[]{"instance_id"};
        }

        public static class ClientResult {
            @SerializedName(value="id")
            private final String id;
            @SerializedName(value="remoteAddress")
            private final String remoteAddress;

            public ClientResult(RelayClient client) {
                this.id = client.getId().toString();
                this.remoteAddress = client.getRemoteAddress().toString();
            }
        }
    }
}

