/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;

public class DeleteChildProcess
extends Route<Void> {
    public DeleteChildProcess(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Void execute() throws Exception {
        ChildProcess childProcess = ChildProcesses.get(this.request.getInput().getParameters().get("id").getValue(new IntegerRequestParameterTransformer()));
        if (!childProcess.hasExited()) {
            throw new IllegalStateException("Child process has not exited yet");
        }
        childProcess.delete();
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    @Override
    public void before() throws Exception {
        Integer id = this.request.getInput().getParameters().get("id").getValue(new IntegerRequestParameterTransformer());
        if (!ChildProcesses.exists(id)) {
            throw new ChildProcessNotFoundException("Child process " + id + " not found");
        }
    }
}

