/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessNotFoundException;
import com.gamedash.daemon.process.ProcessPriorityEnum;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.DiskResourceLimit;
import com.gamedash.daemon.process.resource.limit.RAMResourceLimit;
import com.gamedash.daemon.system.hardware.processor.Processor;
import com.gamedash.daemon.system.hardware.processor.Processors;
import java.util.List;
import java.util.stream.Collectors;

public class LimitProcessResources
extends Route<String> {
    public LimitProcessResources(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        DiskResourceLimit diskResourceLimit;
        RAMResourceLimit ramResourceLimit;
        int id = this.request.getInput().getParameters().get("id").getValue(new IntegerRequestParameterTransformer());
        if (!Processes.exists(id)) {
            throw new ProcessNotFoundException(id);
        }
        IProcess<?> process = Processes.get(id);
        CPUResourceLimit cpuResourceLimit = this.getCPUResourceLimit();
        if (cpuResourceLimit != null) {
            process.setCPUResourceLimit(cpuResourceLimit);
        }
        if ((ramResourceLimit = this.getRAMResourceLimit()) != null) {
            process.setRAMResourceLimit(ramResourceLimit);
        }
        if ((diskResourceLimit = this.getDiskResourceLimit()) != null) {
            process.setDiskResourceLimit(diskResourceLimit);
        }
        process.ensureIsEnforcingResourceLimits();
        return null;
    }

    private CPUResourceLimit getCPUResourceLimit() throws Exception {
        Integer percentage = this.request.getInput().getParameters().exists("cpuPercentage") ? this.request.getInput().getParameters().get("cpuPercentage").getValue(new IntegerRequestParameterTransformer()) : null;
        List<Processor> affinityProcessors = this.request.getInput().getParameters().exists("cpuAffinity") ? this.request.getInput().getParameters().get("cpuAffinity").getIntegerList().stream().map(Processors::get).collect(Collectors.toList()) : null;
        ProcessPriorityEnum processPriority = this.getCPUResourceLimitPriority();
        if (percentage == null && affinityProcessors == null && processPriority == null) {
            return null;
        }
        CPUResourceLimit cpu = new CPUResourceLimit();
        if (percentage != null) {
            cpu.setPercentage(percentage);
        }
        if (affinityProcessors != null) {
            cpu.setProcessorAffinity(affinityProcessors);
        }
        if (processPriority != null) {
            cpu.setPriority(processPriority);
        }
        return cpu;
    }

    private ProcessPriorityEnum getCPUResourceLimitPriority() throws Exception {
        if (this.request.getInput().getParameters().exists("cpuPriority")) {
            for (ProcessPriorityEnum priority : ProcessPriorityEnum.values()) {
                if (!priority.getName().equals(this.request.getInput().getParameters().get("cpuPriority").getValue())) continue;
                return priority;
            }
        }
        return null;
    }

    private RAMResourceLimit getRAMResourceLimit() throws RequestParameterException {
        Integer mb;
        Integer n = mb = this.request.getInput().getParameters().exists("ramMB") ? this.request.getInput().getParameters().get("ramMB").getValue(new IntegerRequestParameterTransformer()) : null;
        if (mb == null) {
            return null;
        }
        RAMResourceLimit ram = new RAMResourceLimit();
        if (mb != null) {
            ram.setMB(mb);
        }
        return ram;
    }

    private DiskResourceLimit getDiskResourceLimit() throws RequestParameterException {
        Integer mbs;
        Integer n = mbs = this.request.getInput().getParameters().exists("diskMBs") ? this.request.getInput().getParameters().get("diskMBs").getValue(new IntegerRequestParameterTransformer()) : null;
        if (mbs == null) {
            return null;
        }
        DiskResourceLimit disk = new DiskResourceLimit();
        if (mbs != null) {
            disk.setMBs(mbs);
        }
        return disk;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }
}

