/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class GetAllProcess
extends Route<List<?>> {
    public GetAllProcess(Request request, Response response) throws Exception {
        super(request, response);
    }

    @Override
    public List<ResponseProcess> execute() throws Exception {
        ArrayList<ResponseProcess> processes = new ArrayList<ResponseProcess>();
        for (IProcess<?> process : Processes.getAll()) {
            processes.add(new ResponseProcess(process));
        }
        return processes;
    }

    private static class ResponseProcess {
        @SerializedName(value="id")
        private int id;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="commandLine")
        private String[] commandLine;
        @SerializedName(value="workingDirectory")
        private String workingDirectory;
        @SerializedName(value="isSelf")
        private boolean isSelf;

        public ResponseProcess(IProcess process) throws Exception {
            this.id = process.getId();
            this.name = process.getName();
            this.commandLine = process.getCommandLine();
            this.workingDirectory = process.getWorkingDirectory().toString();
            this.isSelf = process.isSelf();
        }
    }
}

