/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.LongRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.exception.InvalidArgumentException;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunk;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunks;
import com.google.gson.annotations.SerializedName;
import java.io.InputStream;
import java.util.UUID;
import javax.servlet.http.Part;

public class WriteChunk
extends Route<Object> {
    public WriteChunk(Request request, Response response) {
        super(request, response);
    }

    @Override
    public WriteChunkResult execute() throws Exception {
        Part chunkContentPart = this.request.getRaw().getPart("chunkContent");
        if (chunkContentPart == null) {
            throw new InvalidArgumentException("No file detected");
        }
        if (chunkContentPart.getSize() == 0L) {
            throw new InvalidArgumentException("Uploaded file is empty");
        }
        InputStream inputStream = chunkContentPart.getInputStream();
        UUID sessionId = UUID.fromString(this.request.getInput().getParameters().get("session_id").getValue());
        long chunkId = this.request.getInput().getParameters().get("chunk_id").getValue(new LongRequestParameterTransformer());
        if (!Sessions.exists(sessionId)) {
            throw new Exception("Session does not exist");
        }
        Session session = Sessions.get(sessionId);
        Chunks chunks = session.getChunks();
        Chunk chunk = chunks.get(chunkId);
        if (chunk.hasReceived()) {
            throw new Exception("Already received chunk " + chunkId);
        }
        chunk.receive(inputStream);
        if (chunks.hasReceivedAll()) {
            chunks.merge();
            session.delete();
            return new WriteChunkResult(true);
        }
        return new WriteChunkResult(false);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"session_id", "chunk_id"};
    }

    private static class WriteChunkResult {
        @SerializedName(value="hasReceivedAll")
        private boolean hasReceivedAll;

        public WriteChunkResult(boolean hasReceivedAll) {
            this.hasReceivedAll = hasReceivedAll;
        }
    }
}

