/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents;

import com.gamedash.daemon.api.server.model.fileSystem.file.FileModel;
import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.api.server.route.routes.fileSystem.file.directory.contents.GetContents;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.fileSystem.file.filters.RootDirectoryFileFilter;
import com.gamedash.daemon.fileSystem.file.filters.SymlinkIgnoringFileFilter;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class WalkDirectories
extends GetContents {
    public WalkDirectories(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<FileModel> execute() throws Exception {
        return super.execute();
    }

    @Override
    protected List<File> getRootFiles(File directory) {
        return (List)FileUtils.listFilesAndDirs(directory, SymlinkIgnoringDirectoryFilter.instance, new LocalSymlinkIgnoringFileFilter(this.getDirectoryIgnoreThreshold()));
    }

    private Integer getDirectoryIgnoreThreshold() {
        if (this.request.getInput().getParameters().exists("directoryIgnoreThreshold")) {
            return this.request.getInput().getParameters().get("directoryIgnoreThreshold").getValue(new IntegerRequestParameterTransformer());
        }
        return null;
    }

    private static class SymlinkIgnoringDirectoryFilter
    extends SymlinkIgnoringFileFilter {
        private static final SymlinkIgnoringDirectoryFilter instance = new SymlinkIgnoringDirectoryFilter();

        private SymlinkIgnoringDirectoryFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (!super.accept(file)) {
                return false;
            }
            return file.isDirectory();
        }
    }

    private static class LocalSymlinkIgnoringFileFilter
    extends SymlinkIgnoringFileFilter {
        private final Integer ignoreThreshold;

        public LocalSymlinkIgnoringFileFilter(Integer ignoreThreshold) {
            this.ignoreThreshold = ignoreThreshold;
        }

        @Override
        public boolean accept(File directory) {
            Collection<File> subDirectories;
            if (!directory.isDirectory()) {
                return false;
            }
            if (this.ignoreThreshold != null && (subDirectories = FileUtils.listFilesAndDirs(directory, new RootDirectoryFileFilter(directory), new RootDirectoryFileFilter(directory))).size() > this.ignoreThreshold) {
                return false;
            }
            return super.accept(directory);
        }
    }
}

