/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.compression;

import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.compression.GZipArchive;
import com.gamedash.daemon.compression.TarArchive;
import com.gamedash.daemon.compression.XZArchive;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnTar
extends Route<String>
implements FileSystemSystemUserTrait {
    public static final Logger logger = LoggerFactory.getLogger(UnTar.class);

    public UnTar(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File origin = this.getOrigin();
        File destination = this.getDestination();
        if (!origin.exists() || !origin.isFile()) {
            throw new FileNotFoundException("Origin file does not exist");
        }
        File source = origin;
        File uncompressedSource = this.uncompress();
        if (uncompressedSource != null) {
            source = uncompressedSource;
        }
        TarArchive tarArchive = TarArchive.create(source);
        List<File> files = tarArchive.decompress(destination);
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            for (File file : files) {
                try {
                    systemUser.assignFileSystemFilePermission(file);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace(e));
                }
            }
        }
        return null;
    }

    private File uncompress() throws Exception {
        File origin = this.getOrigin();
        List<String> extensions = this.getExtensions();
        if (extensions.contains("gz")) {
            GZipArchive gZipArchive = GZipArchive.create(origin);
            return gZipArchive.decompress();
        }
        if (extensions.contains("xz")) {
            XZArchive xzArchive = XZArchive.create(origin);
            return xzArchive.decompress();
        }
        return null;
    }

    private List<String> getExtensions() throws Exception {
        return Arrays.asList(FilenameUtils.getExtension(this.getOrigin().getPath()).split("\\."));
    }

    private File getOrigin() throws RequestParameterException {
        return FileUtils.fromBase64(this.request.getInput().getParameters().get("origin").getValue());
    }

    private File getDestination() throws RequestParameterException {
        if (this.request.getInput().getParameters().exists("destination")) {
            return FileUtils.fromBase64(this.request.getInput().getParameters().get("destination").getValue());
        }
        return this.getOrigin().getParentFile();
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"origin"};
    }
}

