/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.BooleanRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;

public class MakeExecutable
extends Route<String> {
    public MakeExecutable(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        boolean appliesToOwner = this.appliesToOwner();
        boolean appliesToGroup = this.appliesToGroup();
        boolean appliesToOthers = this.appliesToOthers();
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
        if (appliesToOwner) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (appliesToGroup) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (appliesToOthers) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        Files.setPosixFilePermissions(file.toPath(), permissions);
        return null;
    }

    private boolean appliesToOwner() {
        return !this.request.getInput().getParameters().exists("owner") || this.request.getInput().getParameters().get("owner").getValue(new BooleanRequestParameterTransformer()) != false;
    }

    private boolean appliesToGroup() {
        return this.request.getInput().getParameters().exists("group") && this.request.getInput().getParameters().get("group").getValue(new BooleanRequestParameterTransformer()) != false;
    }

    private boolean appliesToOthers() {
        return this.request.getInput().getParameters().exists("others") && this.request.getInput().getParameters().get("others").getValue(new BooleanRequestParameterTransformer()) != false;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

