/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.api.server.route.routes.fileSystem.FileSystemSystemUserTrait;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileAlreadyExistsException;
import com.gamedash.daemon.system.user.SystemUser;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class Create
extends Route<String>
implements FileSystemSystemUserTrait {
    public Create(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = com.gamedash.daemon.fileSystem.file.FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (file.exists()) {
            throw new FileAlreadyExistsException("File already exists");
        }
        FileUtils.touch(file);
        SystemUser systemUser = this.getSystemUser(this.request, "systemUserName");
        if (systemUser != null) {
            systemUser.assignFileSystemFilePermission(file);
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

