/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.repository;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.Base64RequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.repository.DockerRepository;
import com.gamedash.daemon.docker.repository.image.DockerRepositoryImage;
import com.google.gson.annotations.SerializedName;

public class PullImage
extends Route<Void> {
    private final Docker docker = Docker.getInstance();

    public PullImage(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Void execute() throws Exception {
        String repositoryId = this.request.getInput().getParameters().get("repository_id").getValue(new Base64RequestParameterTransformer());
        DockerRepository repository = this.docker.getRepositories().get(repositoryId);
        repository.getImages().pull(this.getTag());
        return null;
    }

    private String getTag() throws RequestParameterException {
        if (this.request.getInput().getParameters().exists("tag")) {
            return this.request.getInput().getParameters().get("tag").getValue();
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"repository_id"};
    }

    protected static class Result {
        @SerializedName(value="id")
        private String id;
        @SerializedName(value="tags")
        private String[] tags;
        @SerializedName(value="parentId")
        private String parentId;
        @SerializedName(value="size")
        private Long size;
        @SerializedName(value="virtualSize")
        private Long virtualSize;
        @SerializedName(value="sharedSize")
        private Long sharedSize;

        public Result(DockerRepositoryImage image) {
            this.id = image.getId();
            this.tags = image.getTags();
            this.parentId = image.getParentId();
            this.size = image.getSize();
            this.virtualSize = image.getVirtualSize();
            this.sharedSize = image.getSharedSize();
        }
    }
}

