/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.container;

import com.gamedash.daemon.api.server.helpers.docker.container.DockerContainerHelpers;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.io.listener.DockerContainerRelayIOListener;
import java.util.List;

public class StartContainer
extends Route<String> {
    private final Docker docker = Docker.getInstance();

    public StartContainer(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        DockerContainer container = this.getContainer();
        this.attachListeners(container);
        container.start();
        return null;
    }

    private void attachListeners(DockerContainer container) throws Exception {
        List<String> relayChannelNames = this.getRelayChannelNames();
        if (relayChannelNames != null) {
            this.attachRelayListeners(container);
            container.getIo().ensureIsAttached();
        }
    }

    private void attachRelayListeners(DockerContainer container) throws Exception {
        List<String> relayChannelNames = this.getRelayChannelNames();
        if (relayChannelNames != null) {
            DockerContainerRelayIOListener listener = container.getIo().acquireListener(DockerContainerRelayIOListener.class);
            for (String channelName : relayChannelNames) {
                if (listener.hasChannel(channelName)) continue;
                listener.addChannel(channelName);
            }
        }
    }

    private List<String> getRelayChannelNames() {
        if (!this.request.getInput().getParameters().exists("relayChannels")) {
            return null;
        }
        return this.request.getInput().getParameters().get("relayChannels").getList();
    }

    private DockerContainer getContainer() throws Exception {
        String id = this.request.getInput().getParameters().get("container_id").getValue();
        return this.docker.getContainers().get(id);
    }

    @Override
    public void before() throws Exception {
        DockerContainerHelpers.ensureExists(this.request.getInput().getParameters().get("container_id").getValue());
        DockerContainerHelpers.ensureIsNotRunning(this.request.getInput().getParameters().get("container_id").getValue());
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"container_id"};
    }
}

