/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.model.docker.container;

import com.gamedash.daemon.api.server.model.docker.container.DockerContainerHostConfigModel;
import com.gamedash.daemon.api.server.model.docker.container.DockerContainerMountModel;
import com.gamedash.daemon.api.server.model.docker.container.DockerContainerPortModel;
import com.gamedash.daemon.api.server.model.docker.container.DockerNetworkModel;
import com.gamedash.daemon.api.server.model.docker.container.io.DockerContainerIoTelemetryModel;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.io.listener.DockerContainerRelayIOListener;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DockerContainerModel {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="imageId")
    private final String imageId;
    @SerializedName(value="names")
    private final List<String> names;
    @SerializedName(value="labels")
    private final Map<String, String> labels;
    @SerializedName(value="rootSize")
    private final Long rootSize;
    @SerializedName(value="hostConfig")
    private DockerContainerHostConfigModel hostConfig;
    @SerializedName(value="mounts")
    private List<DockerContainerMountModel> mounts;
    @SerializedName(value="ports")
    private List<DockerContainerPortModel> ports;
    @SerializedName(value="networks")
    private List<DockerNetworkModel> networks;
    @SerializedName(value="isRunning")
    private boolean isRunning;
    @SerializedName(value="io")
    private DockerContainerIoTelemetryModel io;
    @SerializedName(value="relayChannels")
    private List<String> relayChannels = new ArrayList<String>();
    @SerializedName(value="timestampStarted")
    private Long timestampStarted;
    @SerializedName(value="timestampCreated")
    private Long timestampCreated;

    public DockerContainerModel(DockerContainer container) throws Exception {
        Time timeCreated;
        this.id = container.getId();
        this.imageId = container.getImageId();
        this.names = container.getNames();
        this.labels = container.getLabels();
        this.rootSize = container.getRootSize();
        this.isRunning = container.isRunning();
        DockerContainerRelayIOListener listener = container.getIo().getListener(DockerContainerRelayIOListener.class);
        if (listener != null) {
            this.relayChannels = listener.getChannels().stream().map(RelayChannel::getName).collect(Collectors.toList());
        }
        this.io = new DockerContainerIoTelemetryModel(container);
        this.hostConfig = new DockerContainerHostConfigModel(container.getHostConfig());
        this.mounts = container.getMounts().stream().map(DockerContainerMountModel::new).collect(Collectors.toList());
        this.ports = container.getPorts().stream().map(DockerContainerPortModel::new).collect(Collectors.toList());
        this.networks = container.getNetworks().stream().map(DockerNetworkModel::new).collect(Collectors.toList());
        Time timeStarted = container.getTimeStarted();
        if (timeStarted != null) {
            this.timestampStarted = timeStarted.getTimestamp();
        }
        this.timestampCreated = (timeCreated = container.getTimeCreated()) != null ? Long.valueOf(timeCreated.getTimestamp()) : null;
    }
}

