/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Proxy;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.easymock.classextension.ConstructorArgs;
import org.easymock.classextension.internal.ClassProxyFactory;
import org.easymock.internal.MocksControl;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.RuntimeExceptionWrapper;

public final class ClassExtensionHelper {
    private static final ThreadLocal<ConstructorArgs> currentConstructorArgs = new ThreadLocal();

    private ClassExtensionHelper() {
    }

    public static void setCurrentConstructorArgs(ConstructorArgs args) {
        currentConstructorArgs.set(args);
    }

    public static ConstructorArgs getCurrentConstructorArgs() {
        return currentConstructorArgs.get();
    }

    public static ClassProxyFactory.MockMethodInterceptor getInterceptor(Object mock) {
        Factory factory = (Factory)mock;
        return (ClassProxyFactory.MockMethodInterceptor)factory.getCallback(0);
    }

    public static MocksControl getControl(Object mock) {
        try {
            ObjectMethodsFilter handler;
            if (Enhancer.isEnhanced(mock.getClass())) {
                handler = (ObjectMethodsFilter)ClassExtensionHelper.getInterceptor(mock).getHandler();
            } else if (Proxy.isProxyClass(mock.getClass())) {
                handler = (ObjectMethodsFilter)Proxy.getInvocationHandler(mock);
            } else {
                throw new RuntimeExceptionWrapper(new IllegalArgumentException("Not a mock: " + mock.getClass().getName()));
            }
            return handler.getDelegate().getControl();
        }
        catch (ClassCastException e) {
            throw new RuntimeExceptionWrapper(new IllegalArgumentException("Not a mock: " + mock.getClass().getName()));
        }
    }
}

