/*
 * Decompiled with CFR 0.152.
 */
package com.schokkerit.restapi.client.response;

import com.schokkerit.restapi.client.ApiQuery;
import com.schokkerit.restapi.client.ApiQueryException;
import com.schokkerit.restapi.client.response.IQueryResponse;
import com.schokkerit.restapi.client.response.IQueryResponseErrorHandlerCallback;
import com.schokkerit.restapi.client.response.QueryResponseErrorHandler;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public class QueryResponseErrorHandlerManager<T extends IQueryResponse> {
    public ApiQuery query;
    private final Deque<QueryResponseErrorHandler<T>> handlers = new ArrayDeque<QueryResponseErrorHandler<T>>();

    public QueryResponseErrorHandlerManager(ApiQuery query) {
        this.query = query;
        this.registerDefault();
    }

    public void registerHandler(IQueryResponseErrorHandlerCallback<T> callback) {
        this.registerHandler(new QueryResponseErrorHandler<T>(callback));
    }

    public void registerHandler(QueryResponseErrorHandler<T> handler) {
        this.handlers.add(handler);
    }

    public void handleIncoming(T response) {
        Iterator<QueryResponseErrorHandler<T>> iterator = this.handlers.descendingIterator();
        while (iterator.hasNext()) {
            QueryResponseErrorHandler<T> handler = iterator.next();
            handler.execute(response);
        }
    }

    protected void registerDefault() {
        this.registerHandler((T response) -> {
            throw new ApiQueryException("Query returned " + response.getStatusCode());
        });
    }
}

