/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.system;

import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResult;
import com.gamedash.daemon.platform.windows.bridge.result.WindowsBridgeResults;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.shutdown.ShutdownManager;
import com.gamedash.daemon.system.OperatingSystemArchitectureEnum;
import java.util.HashMap;
import org.apache.commons.lang3.SystemUtils;
import oshi.SystemInfo;

public class OperatingSystem {
    private static SystemInfo systemInfo = new SystemInfo();

    public static OperatingSystemArchitectureEnum getArchitecture() {
        HashMap<String, OperatingSystemArchitectureEnum> archMap = new HashMap<String, OperatingSystemArchitectureEnum>();
        archMap.put("x86", OperatingSystemArchitectureEnum.x86);
        archMap.put("i386", OperatingSystemArchitectureEnum.x86);
        archMap.put("i486", OperatingSystemArchitectureEnum.x86);
        archMap.put("i586", OperatingSystemArchitectureEnum.x86);
        archMap.put("i686", OperatingSystemArchitectureEnum.x86);
        archMap.put("x86_64", OperatingSystemArchitectureEnum.x64);
        archMap.put("amd64", OperatingSystemArchitectureEnum.x64);
        if (!archMap.containsKey(SystemUtils.OS_ARCH)) {
            return null;
        }
        return (OperatingSystemArchitectureEnum)((Object)archMap.get(SystemUtils.OS_ARCH));
    }

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static String getVersion() {
        return systemInfo.getOperatingSystem().getVersionInfo().getVersion();
    }

    public static String getCodeName() {
        return systemInfo.getOperatingSystem().getVersionInfo().getCodeName();
    }

    public static String getBuildNumber() {
        return systemInfo.getOperatingSystem().getVersionInfo().getBuildNumber();
    }

    public static long getUptime() {
        return systemInfo.getOperatingSystem().getSystemUptime();
    }

    public static void shutdown() throws Exception {
        ShutdownManager.run();
        if (SystemUtils.IS_OS_WINDOWS) {
            WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().shutdownOperatingSystem());
            if (result.isError()) {
                throw new Exception(result.getErrorMessage());
            }
        } else {
            ChildProcess childProcess = ChildProcesses.create();
            childProcess.spawn("shutdown", new String[0]);
            childProcess.waitForExit();
        }
    }

    public static void reboot() throws Exception {
        ShutdownManager.run();
        if (OperatingSystem.isWindows()) {
            WindowsBridgeResult result = WindowsBridgeResults.get(WindowsBridge.getInstance().rebootOperatingSystem());
            if (result.isError()) {
                throw new Exception(result.getErrorMessage());
            }
        } else {
            ChildProcess childProcess = ChildProcesses.create();
            childProcess.spawn("reboot", new String[0]);
            childProcess.waitForExit();
        }
    }
}

