/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.crash;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.crash.GlobalCrashManager;
import com.gamedash.daemon.process.crash.report.CrashReport;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalCrashManagerWorker {
    private static final Logger logger = LoggerFactory.getLogger(ChildProcess.class);
    private Thread thread;
    private final int tickInterval = 5000;

    private void tick() {
        if (Application.args.logChildProcess.booleanValue()) {
            logger.info("Crash manager worker tick with " + GlobalCrashManager.getQueuedReports().size() + " reports to process");
        }
        for (CrashReport report : GlobalCrashManager.getQueuedReports()) {
            try {
                if (Application.args.logChildProcess.booleanValue()) {
                    logger.info("Sending process crash report");
                }
                report.send();
                GlobalCrashManager.dequeueReport(report);
            }
            catch (Exception e) {
                if (report.getRetryCount() > 5) {
                    GlobalCrashManager.dequeueReport(report);
                }
                report.incrementRetryCount();
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
    }

    public void start() {
        logger.info("Starting global child process crash manager worker");
        this.thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        this.tick();
                        Objects.requireNonNull(this);
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }
}

