/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal;

import com.gamedash.daemon.process.childProcess.terminal.ExitListener;
import com.gamedash.daemon.process.childProcess.terminal.IOnExitCallback;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTerminal
implements ITerminal {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTerminal.class);
    protected ExitListener exitListener = new ExitListener();
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition exitedSync = this.takeLock.newCondition();
    private volatile boolean exited = false;

    @Override
    public void waitForExit() throws Exception {
        this.waitForExit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForExit(Integer seconds) throws Exception {
        Condition condition = this.exitedSync;
        synchronized (condition) {
            while (!this.hasExited()) {
                if (seconds != null) {
                    this.exitedSync.wait(seconds.intValue());
                    break;
                }
                this.exitedSync.wait();
            }
        }
    }

    @Override
    public void onExit(IOnExitCallback callback) {
        this.onExit(callback, false);
    }

    public void onExit(IOnExitCallback callback, boolean priority) {
        if (this.hasExited()) {
            callback.invoke();
        }
        IOnExitCallback wrappedCallback = () -> {
            try {
                callback.invoke();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        };
        if (priority) {
            this.exitListener.unshiftCallback(wrappedCallback);
        } else {
            this.exitListener.addCallback(wrappedCallback);
        }
    }

    @Override
    public void onExitWithPriority(IOnExitCallback callback) {
        this.onExit(callback, true);
    }

    @Override
    public boolean hasExited() {
        return this.exited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasExited(boolean exited) {
        Condition condition = this.exitedSync;
        synchronized (condition) {
            this.exited = exited;
            this.exitedSync.notifyAll();
        }
    }

    protected void handleExit() {
        try {
            this.getIo().waitFor(5);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
        }
        this.exitListener.invoke();
        this.setHasExited(true);
    }
}

