/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.crash.report;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.crash.report.CrashReport;
import com.gamedash.daemon.process.crash.report.CrashReportProcessPropagatingException;
import com.gamedash.daemon.process.crash.report.ICrashReportSender;

public class CrashReportSender
implements ICrashReportSender {
    private final ChildProcess childProcess;

    public CrashReportSender(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    @Override
    public void send(CrashReport report) throws Exception {
        ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/process/childprocess/" + this.childProcess.getId() + "/crash/report");
        query.getResponseErrorHandlerManager().registerHandler(response -> {
            if (response.getErrorCode().equals("PROCESS_PROPAGATING")) {
                throw new CrashReportProcessPropagatingException("Process is propagating");
            }
        });
        query.post();
    }
}

